 /**
 * 通用的一些js方法，后续根据需要进行补充
 */
var commonFunc={
		   tel : /^([0]\d{2,3})-(\d{7,8})$/,
		   mobie :/^(((13[0-9]{1})|(15[0-9]{1})|(18[0-9]{1})|(147)|(170)|(173)|(176)|(177)|(178))+\d{8})$/,
		   chineseStrReg : /^([\u4e00-\u9fa5\s])*$/,
		   posIntetest : /^\+?[1-9][0-9]*$/,
		   isEmpty : function(value) {
		      return value == null || value == "" || value == undefined || value == "undefined"
		    },
		    isNotEmpty : function(value) {
		      return value != null && value != "" && value != undefined && value != "undefined"
		    },
		    posIntetestRule:{
		    	    errmsg: "[label]必须为正整数！",
		    		ruleType: "CUSREGEXP",
		    		value:  /^\+?[1-9][0-9]*$/
		    },
		    //非负整数或为空
		    nonnegativeRule:{
		    	errmsg: "[label]必须为有效数字！",
		    	ruleType: "REGEXP",
		    	value:  /^\+?[1-9][0-9]*$/
		    },
		    isUndefined:function(value){
		    	return value == undefined || value == "undefined"
		    },isFalse:function(value){
		    	return value == false || value == "false"
		    },isHasFalse:function(arry){
		    	for(var i in arry){
		    		var item = arry[i];
		    		if(commonFunc.isFalse(item)){
		    			return true;
		    		}
		    	}
		    },transferEmpty:function(value){
		    	if(commonFunc.isEmpty(value) || value == 0){
		    		return '-'
		    	}else{
		    		return value;
		    	}
		    },transferEmptyToZero:function(value){
		    	if(commonFunc.isEmpty(value)){
		    		return '0.00'
		    	}else{
		    		return value;
		    	}
		    }
		    
}




commonFunc.getLocalStorage = function (key, isJson) {
    if (!commonFunc.supportStroage()) {
        //cpic.alert("暂不支持无痕浏览!");
        return;
    }
    if (window.localStorage) {
        var value = window.localStorage[key] || "";
        if (isJson && value) {
            value = JSON.parse(value);
        }
        return value;
    }
};

/**
 * removelocalStorage
 */
commonFunc.removeLocalStorage = function (key) {
    if (!commonFunc.supportStroage()) {
        //cpic.alert("暂不支持无痕浏览!");
        return;
    }
    if (window.localStorage) {
        window.localStorage.removeItem(key);
    }
};

/**
 * setLocalStorage
 */
commonFunc.setLocalStorage = function (key, value, isJson) {
    if (!commonFunc.supportStroage()) {
        //cpic.alert("暂不支持无痕浏览!");
        return;
    }
    if (window.localStorage) {
        if (isJson) {
            value = JSON.stringify(value);
        }
        try {
            window.localStorage[key] = value;
        } catch (e) {
            //处于无痕模式时，存放到cookie当中
        }

    } 
};

commonFunc.supportStroage = function () {
    var flag = true;
    try {
        if (window.localStorage) {
            //window.localStorage['test'] = "test";
        } else {
            flag = false;
        }
    } catch (e) { //对于无痕模式下会出现异常
        flag = false;
    }
    return flag;
};

var errCodeforErrDesc = {
"E001":"手机号重复",
"E002":"重复的MoveKey",
"E003":"重复的UserName",
"E005":"不存在的手机号码",
"E006":"手机号已经存在",
"E007":"消息发送错误",
"E008":"无效的手机验证码",
"E009":"不合法的密码",
"E0010":"不合法的手机号",
"E0011":"不合法的MoveID",
"E0012":"错误的旧密码",
"E0013":"相同的密码",
"E0014":"无效的密码",
"E0015":"其他的密码错误",
"E0016":"错误的请求",
"E0017":"无效的DeviceID",
"E0018":"设备正在使用",
"E0019":"MoveKey不存在",
"E0020":"MoveKey已经被激活了",
"E021":"不合法的MoveKey",
"E022":"不存在的账户"

}








	
